package ru.yandex.solomon.gateway.api.v3alpha.cloud.priv;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.gateway.api.v3alpha.cloud.priv.validators.NamesValidator;
import ru.yandex.solomon.gateway.api.v3alpha.cloud.priv.validators.ParametersValidator;

/**
 * @author Alexey Trushkin
 */
@Configuration
@ParametersAreNonnullByDefault
public class ServiceDashboardValidationContext {

    @Bean
    public NamesValidator namesValidator() {
        return new NamesValidator();
    }

    @Bean
    public ParametersValidator parametersValidator() {
        return new ParametersValidator();
    }

    @Bean
    public ServiceDashboardValidationService serviceDashboardValidationService(List<ServiceDashboardValidator> validators) {
        return new ServiceDashboardValidationService(validators);
    }
}
