package ru.yandex.solomon.gateway.api.v3alpha.cloud.priv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.concurrent.CompletableFutures;
import ru.yandex.monitoring.v3.cloud.ServiceDashboard;
import ru.yandex.monitoring.v3.cloud.priv.ServiceDashboardValidationIssue;
import ru.yandex.monitoring.v3.cloud.priv.ValidationServiceDashboardResponse;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class ServiceDashboardValidationService {

    private final List<ServiceDashboardValidator> validators;

    public ServiceDashboardValidationService(List<ServiceDashboardValidator> validators) {
        this.validators = validators;
    }

    public CompletableFuture<ValidationServiceDashboardResponse> validate(ServiceDashboard serviceDashboard) {
        List<CompletableFuture<Collection<ServiceDashboardValidationIssue>>> futures = new ArrayList<>(validators.size());
        for (ServiceDashboardValidator validator : validators) {
            futures.add(validator.validate(serviceDashboard));
        }
        return CompletableFutures.allOf(futures)
                .thenApply(collections -> {
                    var builder = ValidationServiceDashboardResponse.newBuilder();
                    for (Collection<ServiceDashboardValidationIssue> collection : collections) {
                        builder.addAllValidationIssues(collection);
                    }
                    return builder.build();
                });
    }
}
