package ru.yandex.solomon.gateway.api.v3alpha.cloud.priv.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.monitoring.v3.cloud.ServiceDashboard;
import ru.yandex.monitoring.v3.cloud.Widget;
import ru.yandex.monitoring.v3.cloud.priv.ServiceDashboardValidationIssue;
import ru.yandex.solomon.gateway.api.v3alpha.cloud.priv.ServiceDashboardValidator;

/**
 * @author Alexey Trushkin
 */
public class NamesValidator implements ServiceDashboardValidator {

    private static final String NAME_WARN = "Name '%s' should be specified and starts with a capital letter";

    @Override
    public CompletableFuture<Collection<ServiceDashboardValidationIssue>> validate(ServiceDashboard serviceDashboard) {
        List<ServiceDashboardValidationIssue> result = new ArrayList<>();
        validateName(serviceDashboard.getName(), result);
        validateWidgets(serviceDashboard, result);
        return CompletableFuture.completedFuture(result);
    }

    private void validateWidgets(
            ServiceDashboard serviceDashboard,
            List<ServiceDashboardValidationIssue> result)
    {
        for (Widget widget : serviceDashboard.getWidgetsList()) {
            if (widget.hasTitle()) {
                validateName(widget.getTitle().getText(), result);
            }
            if (widget.hasChart()) {
                validateName(widget.getChart().getTitle(), result);
            }
            if (widget.hasText()) {
                validateName(widget.getText().getText(), result);
            }
        }
    }

    private void validateName(String value, List<ServiceDashboardValidationIssue> result) {
        if (value.isBlank() || !Character.isUpperCase(value.charAt(0))) {
            result.add(ServiceDashboardValidationIssue.newBuilder()
                    .setSeverity(ServiceDashboardValidationIssue.Severity.WARN)
                    .setDescription(String.format(NAME_WARN, value))
                    .build());
        }
    }

}
