package ru.yandex.solomon.gateway.api.v3alpha.dao.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.util.JsonFormat;
import com.google.protobuf.util.Timestamps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.monitoring.v3.Dashboard;
import ru.yandex.solomon.conf.db3.ydb.Entity;
import ru.yandex.solomon.core.container.ContainerType;
import ru.yandex.solomon.gateway.api.v3.intranet.dto.DashboardDtoConverter;
import ru.yandex.solomon.util.Proto;

/**
 * @author Oleg Baryshnikov
 */
@Deprecated
@ParametersAreNonnullByDefault
public class MonitoringDashboardConverter {
    private static final Logger logger = LoggerFactory.getLogger(MonitoringDashboardConverter.class);

    public static Entity encode(Dashboard dashboard, String localId) {
        final String data = toDataJson(dashboard);
        // write only new format
        final ru.yandex.monitoring.api.v3.Dashboard newProto = DashboardDtoConverter.fromAlphaDashboardModel(dashboard, localId);

        return Entity.newBuilder()
            .setParentId(dashboard.getProjectId())
            .setId(dashboard.getId())
            .setLocalId(localId)
            .setContainerType(ContainerType.PROJECT)
            .setName(dashboard.getName())
            .setDescription(dashboard.getDescription())
            .setProto(Proto.pack(newProto))
            .setData(data)
            .setCreatedAt(Timestamps.toMillis(dashboard.getCreatedAt()))
            .setUpdatedAt(Timestamps.toMillis(dashboard.getUpdatedAt()))
            .setCreatedBy(dashboard.getCreatedBy())
            .setUpdatedBy(dashboard.getUpdatedBy())
            .setVersion((int) dashboard.getVersion())
            .build();
    }

    public static Dashboard decode(Entity entity) {
        final ru.yandex.monitoring.api.v3.Dashboard dashboard = DashboardDtoConverter.fromEntity(entity);
        return DashboardDtoConverter.toAlphaDashboardModel(dashboard);
    }

    public static String toDataJson(Dashboard dashboard) {
        var dataDashboard = Dashboard.newBuilder()
                .addAllWidgets(dashboard.getWidgetsList())
                .setParametrization(dashboard.getParametrization())
                .putAllLabels(dashboard.getLabelsMap())
                .setTitle(dashboard.getTitle())
                .build();

        try {
            return JsonFormat.printer().print(dataDashboard);
        } catch (Exception e) {
            String message = "failed to format dashboard data";
            logger.error(message, e);
            throw new IllegalStateException(message);
        }
    }
}
