package ru.yandex.solomon.gateway.backend.client.data;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.monlib.metrics.labels.Labels;


/**
 * @author Stepan Koltsov
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class WwwDataApiMetric {

    private final Labels labels;
    private final String created;
    private final boolean deriv;
    private final List<WwwMetricValue> values;

    public WwwDataApiMetric(
        Labels labels,
        String created,
        boolean deriv,
        List<WwwMetricValue> values)
    {
        this.labels = labels;
        this.created = created;
        this.deriv = deriv;
        this.values = values;
    }

    public Map<String, String> getLabels() {
        return labels.toMap();
    }

    public List<WwwMetricValue> getValues() {
        return values;
    }

    public String getCreated() {
        return created;
    }

    public boolean isDeriv() {
        return deriv;
    }

}
