package ru.yandex.solomon.gateway.backend.client.www.page;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.doubles.AggregateFunctionType;
import ru.yandex.solomon.math.protobuf.OperationDownsampling;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class DownSamplingParams {
    private long gridMillis;
    private AggregateFunctionType aggrType;
    private OperationDownsampling.FillOption fillOption;
    private boolean ignoreMinStepMillis;

    public DownSamplingParams(
            long gridMillis,
            AggregateFunctionType aggrType,
            OperationDownsampling.FillOption fillOption,
            boolean ignoreMinStepMillis) {
        this.gridMillis = gridMillis;
        this.aggrType = aggrType;
        this.fillOption = fillOption;
        this.ignoreMinStepMillis = ignoreMinStepMillis;
    }

    public long getGridMillis() {
        return gridMillis;
    }

    public AggregateFunctionType getAggrType() {
        return aggrType;
    }

    public OperationDownsampling.FillOption getFillOption() {
        return fillOption;
    }

    public boolean isIgnoreMinStepMillis() {
        return ignoreMinStepMillis;
    }
}
