package ru.yandex.solomon.gateway.backend.data;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.gateway.backend.meta.FrontendMetric;
import ru.yandex.solomon.util.time.Interval;

/**
* @author Stepan Koltsov
*/
@ParametersAreNonnullByDefault
public class MetricDataRequest {
    private final FrontendMetric metric;
    private final Interval interval;

    public MetricDataRequest(FrontendMetric metric, Interval interval) {
        this.metric = metric;
        this.interval = interval;
    }

    @Nonnull
    public FrontendMetric getMetric() {
        return metric;
    }

    @Nonnull
    public Interval getInterval() {
        return interval;
    }
}
