package ru.yandex.solomon.gateway.backend.data;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;


/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class MetricWithGraphData {

    private final MetricDataRequest request;
    @Nonnull
    private final AggrGraphDataArrayList graphData;
    private final Labels labels;
    private final int createdSeconds;
    private final boolean deriv;

    public MetricWithGraphData(MetricDataRequest request, AggrGraphDataArrayList graphData) {
        this.request = request;
        this.graphData = graphData;
        this.labels = request.getMetric().getLabels();
        this.createdSeconds = request.getMetric().getCreatedSeconds();
        this.deriv = request.getMetric().getType() == MetricType.RATE;
    }

    public boolean isDeriv() {
        return deriv;
    }

    public int createdSeconds() {
        return createdSeconds;
    }

    @Nonnull
    public Labels getLabels() {
        return labels;
    }

    @Nonnull
    public AggrGraphDataArrayList getGraphData()  {
        return graphData;
    }

    public MetricDataRequest getRequest() {
        return request;
    }
}
