package ru.yandex.solomon.gateway.backend.meta;

import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.LabelKeys;
import ru.yandex.solomon.model.MetricKey;


/**
 * @author chebik
 */
@ParametersAreNonnullByDefault
public class FrontendMetricPlainImpl implements FrontendMetric {
    private final MetricKey key;
    private final Labels labels;

    public FrontendMetricPlainImpl(MetricKey key) {
        this.key = key;
        this.labels = key.getLabels().toBuilder()
                .remove(LabelKeys.PROJECT)
                .remove(LabelKeys.CLUSTER)
                .remove(LabelKeys.SERVICE)
                .build();
    }

    @Override
    public MetricType getType() {
        return key.getType();
    }

    @Override
    public MetricKey getKey() {
        return key;
    }

    @Override
    public int getCreatedSeconds() {
        return (int) TimeUnit.MILLISECONDS.toSeconds(key.getCreatedAtMillis());
    }

    @Override
    public Labels getLabels() {
        return labels;
    }

    @Override
    public String toString() {
        return key.toString();
    }
}
