package ru.yandex.solomon.gateway.backend.meta.search;

import java.util.List;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.gateway.backend.meta.FrontendMetric;


/**
 * @author chebik
 */
@ParametersAreNonnullByDefault
public class ShardSearchResult {

    private final List<FrontendMetric> metrics;
    private final boolean truncated;

    ShardSearchResult(List<FrontendMetric> metrics, boolean truncated) {
        this.metrics = metrics;
        this.truncated = truncated;
    }

    public Stream<FrontendMetric> getMetricsStream() {
        return metrics.stream();
    }

    public Stream<Labels> getLabelsStream() {
        return getMetricsStream().map(FrontendMetric::getLabels);
    }

    public int size() {
        return metrics.size();
    }

    public boolean isTruncated() {
        return truncated;
    }
}
