package ru.yandex.solomon.gateway.backend.page;

import java.util.Arrays;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;

import ru.yandex.solomon.gateway.utils.UserLinksBasic;
import ru.yandex.solomon.gateway.utils.conf.GraphSettings;
import ru.yandex.solomon.labels.LabelKeys;


/**
 * @author checat
 */
@ParametersAreNonnullByDefault
public class MetricKeySanitizer {

    public MetricKeySanitizer() {
    }

    private static final ImmutableSet<String> prohibitedLabelsExtended;

    static {
        List<String> badLabels = Arrays.asList(
            LabelKeys.PROJECT,
            LabelKeys.CLUSTER,
            LabelKeys.SERVICE);

        // XXX: param names of /generic HTTP-action
        List<String> metricsControllerParams = Arrays.asList(
            UserLinksBasic.PROJECT,
            UserLinksBasic.GRAPH_ONLY_QA,
            UserLinksBasic.NEED_POINTS_PARAM,
            UserLinksBasic.FORCE_HOST_PARAM,
            UserLinksBasic.REVIVER_CLIENT_ID,
            UserLinksBasic.GRAPH_PARAM,
            UserLinksBasic.DASHBOARD_PARAM,
            UserLinksBasic.NEED_POINTS_PARAM,
            UserLinksBasic.LEGEND_QUERY_ARG,
            UserLinksBasic.AUTOREFRESH_QA,
            UserLinksBasic.B_QA,
            UserLinksBasic.E_QA,
            UserLinksBasic.CHECKS_QA,
            UserLinksBasic.IS_BACKGROUND_QUERY_PARAM,
            UserLinksBasic.METADATA_VERSION_HASH_PARAM,
            UserLinksBasic.SOLOMON_CLIENT_VERSION,
            UserLinksBasic.SHOW_CENSORED_INTERVALS,
            UserLinksBasic.DATA_DELAY,
            UserLinksBasic.COUNT_USAGE,
            UserLinksBasic.CHART_BORDER_WIDTH,
            UserLinksBasic.DISTRIBUTION_MODE,
            UserLinksBasic.FORCE_CLUSTER_PARAM,
            UserLinksBasic.ASC_PARAM_DEPRECATED,
            UserLinksBasic.ORDER_BY_PARAM_DEPRECATED
        );

        prohibitedLabelsExtended = ImmutableSet.<String>builder()
            .addAll(badLabels)
            .addAll(GraphSettings.settingNames())
            .addAll(metricsControllerParams)
            .build();
    }

    static boolean isProhibitedLabelName(String labelName) {
        return prohibitedLabelsExtended.contains(labelName);
    }
}
