package ru.yandex.solomon.gateway.backend.page;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.solomon.gateway.utils.UserLinksBasic;
import ru.yandex.solomon.labels.selector.LabelSelectorSet;


/**
 * @author Stepan Koltsov
 */
public final class WwwQueryArgsUtils {

    public static LabelSelectorSet selectorsFromQuery(Map<String, String> queryArgs) {
        final Map<String, String> newQueryArgs;

        newQueryArgs = filterArgsUsingKnownSettings(queryArgs);

        return LabelSelectorSet.fromMap(newQueryArgs);
    }

    private static Map<String, String> filterArgsUsingKnownSettings(Map<String, String> queryArgs) {
        Map<String, String> newQueryArgs = new HashMap<>(queryArgs.size());

        for (Map.Entry<String, String> entry : queryArgs.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();

            if (value == null || value.isEmpty()) {
                continue;
            }

            if (name.startsWith(UserLinksBasic.LABEL_NAME_QA_PREFIX)) {
                String nameWithoutPrefix =
                    name.substring(UserLinksBasic.LABEL_NAME_QA_PREFIX.length());
                newQueryArgs.put(nameWithoutPrefix, value);
            } else if (!MetricKeySanitizer.isProhibitedLabelName(name)) {
                newQueryArgs.put(name, value);
            }
        }

        return newQueryArgs;
    }
}
