package ru.yandex.solomon.gateway.backend.storage;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.doubles.AggregateFunctionType;
import ru.yandex.solomon.math.protobuf.OperationDownsampling;
import ru.yandex.solomon.math.protobuf.OperationTop;
import ru.yandex.solomon.model.MetricKey;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class MetricStorageRequest {

    protected final Interval interval;
    private final MetricKey key;
    private final long gridMillis;
    private final AggregateFunctionType aggrType;
    private final OperationDownsampling.FillOption fillOption;
    private final boolean ignoreMinStepMillis;
    @Nullable
    private final OperationTop rankFilter;

    public MetricStorageRequest(
        Interval interval,
        MetricKey key,
        long gridMillis,
        AggregateFunctionType aggrType,
        OperationDownsampling.FillOption fillOption,
        boolean ignoreMinStepMillis,
        @Nullable OperationTop rankFilter)
    {
        this.interval = interval;
        this.key = key;
        this.gridMillis = gridMillis;
        this.aggrType = aggrType;
        this.fillOption = fillOption;
        this.ignoreMinStepMillis = ignoreMinStepMillis;
        this.rankFilter = rankFilter;
    }

    public Interval getInterval() {
        return interval;
    }

    public MetricKey getKey() {
        return key;
    }

    public long getGridMillis() {
        return gridMillis;
    }

    public AggregateFunctionType getAggrType() {
        return aggrType;
    }

    public OperationDownsampling.FillOption getFillOption() {
        return fillOption;
    }

    public boolean isIgnoreMinStepMillis() {
        return ignoreMinStepMillis;
    }

    @Nullable
    public OperationTop getRankFilter() {
        return rankFilter;
    }
}
