package ru.yandex.solomon.gateway.backend.www.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.LabelKeys;
import ru.yandex.solomon.labels.LabelValues;
import ru.yandex.solomon.labels.query.Selector;
import ru.yandex.solomon.labels.query.SelectorType;
import ru.yandex.solomon.labels.query.Selectors;


/**
 * @author Stepan Koltsov
 */
public final class WwwLabelUtils {
    private WwwLabelUtils() {}

    public static List<String> getNamingLabels(
        List<String> nonTrivialLabels,
        Optional<Labels> metricLabels,
        Selectors selectorsAfterShard)
    {
        List<String> namesWithAsterisks = selectorsAfterShard.stream()
            .filter(s -> s.getType() == SelectorType.ANY
                || s.getType() == SelectorType.GLOB && LabelValues.ANY.equals(s.getValue()))
            .map(Selector::getKey)
            .collect(Collectors.toList());

        return getNamingLabels(nonTrivialLabels, metricLabels, namesWithAsterisks);
    }

    private static List<String> getNamingLabels(
        List<String> nonTrivialLabels,
        Optional<Labels> metricLabels,
        List<String> namesWithAsterisks)
    {
        List<String> rawNamingLabels = nonTrivialLabels;

        if (nonTrivialLabels.size() > 0) {
            return rawNamingLabels;
        } else {
            String nonTrivialLabelName = LabelKeys.SENSOR;

            if (metricLabels.isPresent()) {
                ArrayList<String> candidateNonTrivialLabelNames = new ArrayList<>();
                candidateNonTrivialLabelNames.addAll(namesWithAsterisks);
                candidateNonTrivialLabelNames.add(LabelKeys.SENSOR);
                candidateNonTrivialLabelNames.add(LabelKeys.PATH);

                // safe default
                if (!metricLabels.get().isEmpty()) {
                    nonTrivialLabelName = metricLabels.get().at(0).getKey();
                } else {
                    nonTrivialLabelName = LabelKeys.SENSOR;
                }

                for (String labelName : candidateNonTrivialLabelNames) {
                    if (metricLabels.get().hasKey(labelName)) {
                        nonTrivialLabelName = labelName;
                        break;
                    }
                }
            }

            return Collections.singletonList(nonTrivialLabelName);
        }
    }
}
