package ru.yandex.solomon.gateway.data;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.metrics.client.combined.OldModeResult;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class DataResponse {
    private final SelValue evalResult;
    private final OldModeResult oldModeResult;

    DataResponse(SelValue evalResult, OldModeResult oldModeResult) {
        this.evalResult = evalResult;
        this.oldModeResult = oldModeResult;
    }

    public SelValue getEvalResult() {
        return evalResult;
    }

    public OldModeResult getOldModeResult() {
        return oldModeResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DataResponse that = (DataResponse) o;

        if (!evalResult.equals(that.evalResult)) {
            return false;
        }
        return oldModeResult.equals(that.oldModeResult);
    }

    @Override
    public int hashCode() {
        int result = evalResult.hashCode();
        result = 31 * result + oldModeResult.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "DataResponse{" +
            "evalResult=" + evalResult +
            ", oldModeResult=" + oldModeResult +
            '}';
    }
}
