package ru.yandex.solomon.gateway.data;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.analytics.GraphDataLoadRequest;
import ru.yandex.solomon.expression.analytics.GraphDataLoader;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
class PreloadedGraphDataLoader implements GraphDataLoader {

    private final Map<GraphDataLoadRequest, List<NamedGraphData>> seriesByRequest;
    private final long gridMillis;

    PreloadedGraphDataLoader(Map<GraphDataLoadRequest, List<NamedGraphData>> seriesByRequest, DownsamplingOptions downsamplingOptions) {
        this.seriesByRequest = seriesByRequest;
        if (downsamplingOptions.getGridMillis() > 0) {
            // BY_INTERVAL downsampling, already rounded to shard grid if GRID_DOWNSAMPLING is set
            this.gridMillis = downsamplingOptions.getGridMillis();
        } else {
            // downsampling is OFF, use shard grid if available
            this.gridMillis = downsamplingOptions.getShardGridMillis();
        }
    }

    @Override
    public NamedGraphData[] loadGraphData(GraphDataLoadRequest request) {
        List<NamedGraphData> series = seriesByRequest.get(request);

        if (series == null) {
            throw new RuntimeException("Not supported loading data with parameters not known at startup.");
        }

        return series.toArray(new NamedGraphData[0]);
    }

    @Override
    public long getSeriesGridMillis() {
        return gridMillis;
    }
}
