package ru.yandex.solomon.gateway.data;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class StockpileMetricDataRequest {

    private final String name;
    private final Labels labels;
    private final Interval interval;
    private final String forceCluster;

    public StockpileMetricDataRequest(String name, Labels labels, Interval interval, String forceCluster) {
        this.name = name;
        this.labels = labels;
        this.interval = interval;
        this.forceCluster = forceCluster;
    }

    public String getName() {
        return name;
    }

    public Labels getLabels() {
        return labels;
    }

    public Interval getInterval() {
        return interval;
    }

    public String getForceCluster() {
        return forceCluster;
    }
}
