package ru.yandex.solomon.gateway.data;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.solomon.model.MetricKey;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class StockpileMetricDataResponse {

    private final MetricType type;
    private final List<ExtendedStockpileKey> stockpileKeys;
    private final AggrGraphDataIterable aggrGraphData;

    StockpileMetricDataResponse(
        MetricKey key,
        List<ExtendedStockpileKey> stockpileKeys,
        AggrGraphDataIterable aggrGraphData)
    {
        this.type = key.getType();
        this.stockpileKeys = stockpileKeys;
        this.aggrGraphData = aggrGraphData;
    }

    public MetricType getType() {
        return type;
    }

    public List<ExtendedStockpileKey> getStockpileKeys() {
        return stockpileKeys;
    }

    public AggrGraphDataIterable getAggrGraphData() {
        return aggrGraphData;
    }
}
