package ru.yandex.solomon.gateway.entityConverter;

import java.io.File;
import java.util.concurrent.Executor;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.net.ssl.SSLException;

import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;

import ru.yandex.solomon.auth.AuthType;
import ru.yandex.solomon.config.protobuf.frontend.EntityConverterConfig;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ApiV3GrpcClientFactory {
    private final AuthCallCredentials credentials;
    private final Channel channel;

    public ApiV3GrpcClientFactory(EntityConverterConfig config, String oauthToken) {
        this.credentials = new AuthCallCredentials(AuthType.OAuth, oauthToken);
        var channelBuilder = NettyChannelBuilder.forAddress(config.getTargetApiUrl(), 443);
        if (!config.getCertPath().isEmpty()) {
            SslContext sslContext;
            try {
                sslContext = GrpcSslContexts.forClient().trustManager(new File(config.getCertPath())).build();
            } catch (SSLException e) {
                throw new RuntimeException(e);
            }
            channelBuilder.negotiationType(NegotiationType.TLS).sslContext(sslContext);
        }
        this.channel = channelBuilder.build();
    }

    public ru.yandex.monitoring.v3.DashboardServiceGrpc.DashboardServiceBlockingStub createDashboardClient() {
        return ru.yandex.monitoring.v3.DashboardServiceGrpc.newBlockingStub(channel)
                .withCallCredentials(credentials);
    }

    public ru.yandex.monitoring.v3.QuickLinksServiceGrpc.QuickLinksServiceBlockingStub createQuickLinksClient() {
        return ru.yandex.monitoring.v3.QuickLinksServiceGrpc.newBlockingStub(channel)
                .withCallCredentials(credentials);
    }

    public ru.yandex.monitoring.v3.priv.AdminDashboardServiceGrpc.AdminDashboardServiceBlockingStub createPrivDashboardClient() {
        return ru.yandex.monitoring.v3.priv.AdminDashboardServiceGrpc.newBlockingStub(channel)
                .withCallCredentials(credentials);
    }

    private static class AuthCallCredentials extends CallCredentials {
        private final AuthType type;
        private final String token;

        private AuthCallCredentials(AuthType type, String token) {
            this.type = type;
            this.token = token;
        }

        @Override
        public void applyRequestMetadata(
                RequestInfo requestInfo,
                Executor appExecutor,
                MetadataApplier applier) {
            Metadata headers = new Metadata();
            String value;
            if (type.getValuePrefix().isEmpty()) {
                value = token;
            } else {
                value = type.getValuePrefix() + token;
            }

            headers.put(type.getMetadataKey(), value);

            applier.apply(headers);
        }

        @Override
        public void thisUsesUnstableApi() {
        }
    }
}
