package ru.yandex.solomon.gateway.entityConverter;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.StringUtils;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ConvertFilterParser {

    public static List<ProjectEntityFilter> parse(String text) {
        if (StringUtils.isBlank(text)) {
            return List.of();
        }

        String[] filters = text.split(",\\s*");
        if (filters.length == 0) {
            throw new IllegalArgumentException("no entity filters found: \"" + text + '"');
        }
        List<ProjectEntityFilter> parsedFilters = new ArrayList<>(filters.length);
        for (String filter : filters) {
            filter = filter.trim();
            if (!filter.contains("/")) {
                parsedFilters.add(ProjectEntityFilter.all(filter));
            } else {
                String[] filterParts = filter.split("/");
                if (filterParts.length == 0) {
                    throw new IllegalArgumentException("no parts found in entity filter: \"" + text + '"');
                }
                String projectId = filterParts[0];
                if (filterParts.length == 1) {
                    parsedFilters.add(ProjectEntityFilter.all(projectId));
                } else if (filterParts.length == 2) {
                    String entityType = filterParts[1];
                    final ProjectEntityFilter.Mode mode;
                    if ("menu".equals(entityType)) {
                        mode = ProjectEntityFilter.Mode.MENU;
                    } else if ("graphs_dashboards".equals(entityType)) {
                        mode = ProjectEntityFilter.Mode.GRAPHS_DASHBOARDS;
                    } else {
                        throw new IllegalArgumentException("unknown entity type " + StringUtils.wrap(entityType, '"') + " in entity filter " + StringUtils.wrap(filter, '"'));
                    }
                    parsedFilters.add(new ProjectEntityFilter(projectId, mode, "", ""));
                } else if (filterParts.length == 3) {
                    String entityType = filterParts[1];
                    String entityId = filterParts[2];
                    final ProjectEntityFilter.Mode mode;
                    if ("dashboards".equals(entityType)) {
                        mode = ProjectEntityFilter.Mode.CONCRETE_DASHBOARD;
                    } else if ("graphs".equals(entityType)) {
                        mode = ProjectEntityFilter.Mode.CONCRETE_GRAPH;
                    } else {
                        throw new IllegalArgumentException("unknown entity type in entity filter " + StringUtils.wrap(filter, '"'));
                    }
                    parsedFilters.add(new ProjectEntityFilter(projectId, mode, entityId, ""));
                } else if (filterParts.length == 4) {
                    String entityType = filterParts[1];
                    String entityId = filterParts[2];
                    String widgetId = filterParts[3];
                    if (!"dashboards".equals(entityType)) {
                        throw new IllegalArgumentException("unknown entity type in entity filter " + StringUtils.wrap(filter, '"'));
                    }
                    parsedFilters.add(new ProjectEntityFilter(projectId, ProjectEntityFilter.Mode.CONCRETE_DASHBOARD, entityId, widgetId));
                } else {
                    throw new IllegalArgumentException("too many parts in  entity filter: \"" + text + '"');
                }
            }
        }

        return parsedFilters;
    }
}
