package ru.yandex.solomon.gateway.entityConverter;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.MessageOrBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.solomon.core.db.model.Dashboard;
import ru.yandex.solomon.core.db.model.ProjectMenu;
import ru.yandex.solomon.core.db.model.graph.Graph;
import ru.yandex.solomon.gateway.api.v2.dto.DashboardDto;
import ru.yandex.solomon.gateway.api.v2.dto.GraphDto;
import ru.yandex.solomon.gateway.api.v2.dto.ProjectMenuDto;
import ru.yandex.solomon.util.protobuf.ProtobufText;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
class DebugInfo {
    private static final Logger logger = LoggerFactory.getLogger(DebugInfo.class);

    private final ObjectMapper mapper;

    public DebugInfo(ObjectMapper objectMapper) {
        this.mapper = objectMapper;
    }

    @SuppressWarnings("UnstableApiUsage")
    public void saveDebugComparison(String projectId, Dashboard oldDashboard, ru.yandex.monitoring.v3.Dashboard newDashboard) {
        try {
            DashboardDto dto = DashboardDto.fromModel(oldDashboard);
            printInfo(dto, newDashboard);
        } catch (Exception e) {
            logger.error("failed to save debug comparison: " + projectId + "/" + oldDashboard.getId(), e);
        }
    }

    @SuppressWarnings("UnstableApiUsage")
    public void saveDebugComparison(String projectId, Graph oldGraph, ru.yandex.monitoring.v3.Dashboard newDashboard) {
        try {
            GraphDto dto = GraphDto.fromModel(oldGraph);
            printInfo(dto, newDashboard);
        } catch (Exception e) {
            logger.error("failed to save debug comparison " + projectId + "/" + oldGraph.getId(), e);
        }
    }

    @SuppressWarnings("UnstableApiUsage")
    public void saveDebugComparison(String projectId, ProjectMenu oldProjectMenu, ru.yandex.monitoring.v3.QuickLinks newQuickLinks) {
        try {
            ProjectMenuDto dto = ProjectMenuDto.fromModel(oldProjectMenu);
            printInfo(dto, newQuickLinks);
        } catch (Exception e) {
            logger.error("failed to save debug comparison " + projectId, e);
        }
    }

    private void printInfo(Object dto, MessageOrBuilder messageOrBuilder) throws JsonProcessingException {
        String old = mapper.writeValueAsString(dto);
        String newStr = ProtobufText.serializeToText(messageOrBuilder);
        logger.debug("Debug data: \nOld:\n {} \n New:\n {}", old, newStr);
    }
}
