package ru.yandex.solomon.gateway.entityConverter;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.db.model.Dashboard;
import ru.yandex.solomon.core.db.model.ProjectMenu;
import ru.yandex.solomon.core.db.model.graph.Graph;

@ParametersAreNonnullByDefault
public interface ExternalLoader {
    CompletableFuture<Graph> loadGraph(String projectId, String graphId);

    CompletableFuture<Dashboard> loadDashboard(String projectId, String dashId);

    CompletableFuture<ProjectMenu> loadProjectMenu(String projectId);

    CompletableFuture<ParsedProjectSettings> loadProjectSettings(String projectId);

    CompletableFuture<Map<String, String>> loadSubAlertLabels(String projectId, String alertId, String subAlertId);

    Set<String> loadProjectIds();

    Collection<Graph> loadProjectGraphs(String projectId);

    Collection<Dashboard> loadProjectDashboards(String projectId);
}
