package ru.yandex.solomon.gateway.entityConverter;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.solomon.core.db.model.graph.Graph;
import ru.yandex.solomon.core.db.model.graph.OverLinesTransform;
import ru.yandex.solomon.gateway.utils.WwwBooleans;
import ru.yandex.solomon.gateway.utils.conf.GraphSetting;
import ru.yandex.solomon.gateway.utils.conf.GraphSettings;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class GraphToSettingsConverter {

    public static Map<String, String> convert(Graph model) {
        Map<String, String> params = new HashMap<>();
        if (model.getStack() != null) {
            params.put(GraphSettings.stack.queryArg, WwwBooleans.formatBoolean(model.getStack()));
        }
        Boolean dropNans = model.isDropNans();
        if (dropNans != null) {
            params.put(GraphSettings.dropNans.queryArg, WwwBooleans.formatBoolean(dropNans));
        }
        Double threshold = model.getThreshold();
        if (threshold != null) {
            params.put(GraphSettings.threshold.queryArg, Double.toString(threshold));
        }
        putIfNeeded(params, GraphSettings.description, model.getDescription());
        putIfNeeded(params, GraphSettings.graphMode, model.getGraphMode());
        putIfNeeded(params, GraphSettings.secondaryGraphMode, model.getSecondaryGraphMode());

        putIfNeeded(params, GraphSettings.min, model.getMin());
        putIfNeeded(params, GraphSettings.max, model.getMax());

        putIfNeeded(params, GraphSettings.norm, model.isNormalize());
        putIfNeeded(params, GraphSettings.cs, model.getColorScheme());
        putIfNeeded(params, GraphSettings.aggr, model.getAggr());
        putIfNeeded(params, GraphSettings.interpolate, model.getInterpolate());
        putIfNeeded(params, GraphSettings.scale, model.getScale());

        putIfNeeded(params, GraphSettings.numberFormat, model.getNumberFormat());
        putIfNeeded(params, GraphSettings.green, model.getGreen());
        putIfNeeded(params, GraphSettings.yellow, model.getYellow());
        putIfNeeded(params, GraphSettings.red, model.getRed());
        putIfNeeded(params, GraphSettings.violet, model.getViolet());
        putIfNeeded(params, GraphSettings.greenValue, model.getGreenValue());
        putIfNeeded(params, GraphSettings.yellowValue, model.getYellowValue());
        putIfNeeded(params, GraphSettings.redValue, model.getRedValue());
        putIfNeeded(params, GraphSettings.violetValue, model.getVioletValue());
        putIfNeeded(params, GraphSettings.limit, model.getLimit());

        if (!model.getOverLinesTransform().equals(OverLinesTransform.NONE)) {
            params.put(GraphSettings.overLinesTransform.queryArg, model.getOverLinesTransform().value().toUpperCase());
        }
        putIfNeeded(params, GraphSettings.percentiles, model.getPercentiles());
        putIfNeeded(params, GraphSettings.bucketLabel, model.getBucketLabel());

        putIfNeeded(params, GraphSettings.filter, model.getFilter());
        putIfNeeded(params, GraphSettings.filterBy, model.getFilterBy());
        putIfNeeded(params, GraphSettings.filterLimit, model.getFilterLimit());

        putIfNeeded(params, GraphSettings.transform, model.getTransform());

        putIfNeeded(params, GraphSettings.movingWindow, model.getMovingWindow());
        putIfNeeded(params, GraphSettings.movingPercentile, model.getMovingPercentile());

        putIfNeeded(params, GraphSettings.downsampling, model.getDownsampling());
        putIfNeeded(params, GraphSettings.downSamplingAggr, model.getDownsamplingAggr());
        putIfNeeded(params, GraphSettings.downsamplingFill, model.getDownsamplingFill());

        putIfNeeded(params, GraphSettings.grid, model.getGrid());

        if (model.getMaxPoints() != 0) {
            params.put(GraphSettings.maxPoints.queryArg, Integer.toString(model.getMaxPoints()));
        }

        putIfNeeded(params, GraphSettings.hideNoData, model.isHideNoData());

        return params;
    }

    private static void putIfNeeded(Map<String, String> params, GraphSetting setting, String value) {
        if (StringUtils.isNoneEmpty(value)) {
            params.put(setting.queryArg, value);
        }
    }

    private static void putIfNeeded(Map<String, String> params, GraphSetting setting, StringEnum stringEnum) {
        String value = stringEnum.value();
        if (!value.equals(setting.defaultValue)) {
            params.put(setting.queryArg, value);
        }
    }

    private static void putIfNeeded(Map<String, String> params, GraphSetting setting, boolean value) {
        if (value) {
            params.put(setting.queryArg, WwwBooleans.formatBoolean(value));
        }
    }
}
