package ru.yandex.solomon.gateway.entityConverter;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.v3.Widget;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public abstract class ParsedWidgetContent {
    public static class SimpleWidget extends ParsedWidgetContent {
        public final Widget widget;

        public SimpleWidget(Widget widget) {
            this.widget = widget;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            SimpleWidget that = (SimpleWidget) o;
            return widget.equals(that.widget);
        }

        @Override
        public int hashCode() {
            return Objects.hash(widget);
        }

        @Override
        public String toString() {
            return "SimpleWidget{" +
                    "widget=" + widget +
                    '}';
        }
    }

    public static class ComplexWidget extends ParsedWidgetContent {
        public final DashScheme<ParsedWidgetContent> dash;

        public ComplexWidget(DashScheme<ParsedWidgetContent> dash) {
            this.dash = dash;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ComplexWidget that = (ComplexWidget) o;
            return dash.equals(that.dash);
        }

        @Override
        public int hashCode() {
            return Objects.hash(dash);
        }

        @Override
        public String toString() {
            return "ComplexWidget{" +
                    "dash=" + dash +
                    '}';
        }
    }
}
