package ru.yandex.solomon.gateway.entityConverter;

/**
 * @author Oleg Baryshnikov
 */
class ProjectEntityFilter {
    public final String projectId;
    public final Mode mode;
    public final String entityId;
    public final String widgetId;

    public ProjectEntityFilter(String projectId, Mode mode, String entityId, String widgetId) {
        this.projectId = projectId;
        this.mode = mode;
        this.entityId = entityId;
        this.widgetId = widgetId;
    }

    public static ProjectEntityFilter all(String projectId) {
        return new ProjectEntityFilter(projectId, Mode.ALL, "", "");
    }

    public String format() {
        return formatEntry() + " in project " + projectId;
    }

    private String formatEntry() {
        switch (mode) {
            case ALL:
                return "all entities";
            case GRAPHS_DASHBOARDS:
                return "all project graphs and dashboards";
            case MENU:
                return "project menu";
            case CONCRETE_GRAPH:
                return "graph " + entityId;
            case CONCRETE_DASHBOARD:
                return "dashboard " + entityId + (widgetId.isEmpty() ? "" : " with widget " + widgetId);
            default:
                throw new IllegalStateException("unknown mode: " + mode);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ProjectEntityFilter that = (ProjectEntityFilter) o;

        if (!projectId.equals(that.projectId)) {
            return false;
        }
        if (mode != that.mode) {
            return false;
        }
        if  (!entityId.equals(that.entityId)) {
            return false;
        }
        return widgetId.equals(that.widgetId);
    }

    @Override
    public int hashCode() {
        int result = projectId.hashCode();
        result = 31 * result + mode.hashCode();
        result = 31 * result + entityId.hashCode();
        result = 31 * result + widgetId.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ProjectEntityFilter{" +
                "projectId='" + projectId + '\'' +
                ", mode=" + mode +
                ", entityId='" + entityId + '\'' +
                ", widgetId='" + widgetId + '\'' +
                '}';
    }

    public enum Mode {
        ALL,
        GRAPHS_DASHBOARDS,
        MENU,
        CONCRETE_GRAPH,
        CONCRETE_DASHBOARD,
    }
}
