package ru.yandex.solomon.gateway.entityConverter;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
class PushClient {
    private static final Map<String, String> PARAMS = Map.of(
            "project", "solomon",
            "cluster", "push",
            "service", "push");


    private final SolomonApiClient client;

    public PushClient(SolomonApiClient client) {
        this.client = client;
    }

    private void pushEvent(String metricName) {
        client.postRequest("/api/v2/push", PARAMS, "{\"metrics\": [{\"name\": \"" + metricName + "\", \"value\": 1}]}").join();
    }
    public void pushStarted() {
        pushEvent("entityConverter.started");
    }

    public void pushFinished() {
        pushEvent("entityConverter.finished");
    }

    public void pushFailed() {
        pushEvent("entityConverter.failed");
    }
}
