package ru.yandex.solomon.gateway.entityConverter;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.tuple.Pair;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class QueryTransformations {
    private static final Set<String> groupLinesFuncs = Set.of("count", "avg", "max", "min", "sum");

    public static Pair<List<String>, Boolean> makeSummary(String rawExpr, String checks) {
        if (checks.startsWith("+")) {
            String checksFunc = checks.substring(1);
            if (groupLinesFuncs.contains(checksFunc)) {
                return Pair.of(List.of("alias(group_lines(\"" + checksFunc + "\", " + rawExpr + "), \"" + checksFunc + "\")"), true);
            }
        }

        var expressions = Stream.of("avg", "count", "max", "min", "sum")
                .map(func -> "alias(group_lines(\"" + func + "\", " + rawExpr + "), \"" + func + "\")")
                .collect(Collectors.toList());
        return Pair.of(expressions, false);
    }
}
