package ru.yandex.solomon.gateway.entityConverter;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.labels.FormatLabel;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class StringInterpolator {
    public static String interpolateName(String pattern) {
        return FormatLabel.formatLabel(pattern, param -> param);
    }

    public static String interpolatePattern(String pattern, Map<String, String> params) {
        return FormatLabel.formatLabel(pattern, param -> params.getOrDefault(param, "{{" + param + "}}"));
    }

    public static String escapePattern(String text) {
        return text.replaceAll("\\{\\{", "\\\\{\\\\{").replaceAll("}}", "\\\\}\\\\}");
    }
}
