package ru.yandex.solomon.gateway.filters;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import io.opentracing.propagation.TextMap;
import org.springframework.http.HttpHeaders;

/**
 * Maps {@code List<String>>} to {@code String} values from HTTP headers.
 *
 * @author Sergey Polovko
 */
final class HttpHeadersAdapter implements TextMap {

    private final HttpHeaders headers;

    public HttpHeadersAdapter(HttpHeaders headers) {
        this.headers = headers;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        var it = headers.entrySet().iterator();
        return new Iterator<>() {
            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Map.Entry<String, String> next() {
                var entry = it.next();
                String key = entry.getKey();
                List<String> values = entry.getValue();
                return Map.entry(key, values.isEmpty() ? "" : values.get(0));
            }
        };
    }

    @Override
    public void put(String key, String value) {
        // nop
    }
}
