package ru.yandex.solomon.gateway.filters;

import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

import ru.yandex.solomon.gateway.utils.FrontendConstants;
import ru.yandex.solomon.util.host.HostUtils;

/**
 * @author Maksim Leonov
 */
@Component
public class VersionHeaderFilter implements WebFilter {

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpResponse response = exchange.getResponse();
        if (response.isCommitted()) {
            return Mono.empty();
        }

        HttpHeaders headers = response.getHeaders();
        headers.set(FrontendConstants.FRONTEND_VERSION_HEADER, Integer.toString(FrontendConstants.FRONTEND_VERSION));
        headers.set("X-Solomon-Host", HostUtils.getFqdn());
        return chain.filter(exchange);
    }
}
