package ru.yandex.solomon.gateway.inject.spring;

import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import ru.yandex.solomon.config.protobuf.alert.TAlertingStatusesShardConfig;
import ru.yandex.solomon.config.protobuf.frontend.TGatewayConfig;
import ru.yandex.solomon.labels.shard.ShardKey;

/**
 * @author Ivan Tsybulin
 */
@Component
public class AlertingStatusesContext {
    @Bean
    ShardKey alertingStatuses(TGatewayConfig gatewayConfig) {
        TAlertingStatusesShardConfig subconfig = gatewayConfig.getAlertingStatusesShardConfig();
        String project = subconfig.getProject();
        String cluster = subconfig.getCluster();
        String service = subconfig.getService();
        if (project.isEmpty()) {
            throw new IllegalArgumentException("Empty project in TGatewayConfig.AlertingStatusesShardConfig");
        }
        if (cluster.isEmpty()) {
            throw new IllegalArgumentException("Empty cluster in TGatewayConfig.AlertingStatusesShardConfig");
        }
        if (service.isEmpty()) {
            throw new IllegalArgumentException("Empty service in TGatewayConfig.AlertingStatusesShardConfig");
        }

        return new ShardKey(project, cluster, service);
    }
}
