package ru.yandex.solomon.gateway.inject.spring;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.discovery.cluster.ClusterMapper;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.flags.FeatureFlagsHolder;
import ru.yandex.solomon.gateway.data.DataClient;
import ru.yandex.solomon.gateway.data.DataClientMetrics;
import ru.yandex.solomon.gateway.data.StockpileMetricClient;
import ru.yandex.solomon.metrics.client.MetricsClient;

/**
 * @author Oleg Baryshnikov
 */
@Configuration
@ParametersAreNonnullByDefault
public class DataClientContext {

    @Bean
    public DataClientMetrics dataClientMetrics() {
        return new DataClientMetrics();
    }

    @Bean
    public DataClient dataClient(
        DataClientMetrics dataClientMetrics,
        MetricsClient metricsClient,
        ClusterMapper clusterMapper,
        MetricRegistry metricRegistry,
        SolomonConfHolder solomonConfHolder,
        FeatureFlagsHolder featureFlagsHolder)
    {
        return new DataClient(dataClientMetrics, metricsClient, clusterMapper, metricRegistry, solomonConfHolder, featureFlagsHolder);
    }

    @Bean
    public StockpileMetricClient stockpileMetricClient(
        MetricsClient metricsClient,
        ClusterMapper clusterMapper)
    {
        return new StockpileMetricClient(metricsClient, clusterMapper);
    }
}
