package ru.yandex.solomon.gateway.inject.spring;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.idempotency.IdempotentOperationContext;

/**
 * @author Nuradil Zhambyl
 */
@Configuration
@ParametersAreNonnullByDefault
public class GatewayIdempotentOperationContext extends IdempotentOperationContext {

    public static final String PATH = "/Gateway/V1/IdempotentOperation";

    public GatewayIdempotentOperationContext(
            @Qualifier("globalTableClient") TableClient tableClient,
            @Qualifier("globalSchemeClient") SchemeClient schemeClient,
            @Qualifier("configKikimrRootPath") String rootPath)
    {
        super(rootPath + PATH, tableClient, schemeClient);
    }
}
