package ru.yandex.solomon.gateway.inject.spring;

import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.config.protobuf.TaskSchedulerConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.core.conf.ShardsManager;
import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.core.db.dao.ShardsDao;
import ru.yandex.solomon.coremon.client.CoremonClient;
import ru.yandex.solomon.gateway.operations.deleteMetrics.DeleteMetricsOperationManager;
import ru.yandex.solomon.gateway.operations.deleteMetrics.DeleteMetricsOperationMetrics;
import ru.yandex.solomon.gateway.operations.deleteMetrics.DeleteMetricsOperationTracker;
import ru.yandex.solomon.gateway.tasks.deleteMetrics.DeleteMetricsTaskHandler;
import ru.yandex.solomon.gateway.tasks.removeShard.RemoveShardTaskHandler;
import ru.yandex.solomon.scheduler.TaskScheduler;
import ru.yandex.solomon.scheduler.context.TaskSchedulerContext;
import ru.yandex.solomon.spring.ConditionalOnBean;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
@ConditionalOnBean(TaskSchedulerConfig.class)
public class GatewaySchedulerContext extends TaskSchedulerContext {
    public GatewaySchedulerContext(
            @Qualifier("globalTableClient") TableClient tableClient,
            @Qualifier("globalSchemeClient") SchemeClient schemeClient,
            @Qualifier("configKikimrRootPath") String rootPath,
            TaskSchedulerConfig schedulerConfig,
            ThreadPoolProvider threads)
    {
        super(rootPath + "/Gateway/V1", schedulerConfig, threads, tableClient, schemeClient);
    }

    @Bean
    public RemoveShardTaskHandler removeShardTaskHandler(CoremonClient coremon, ShardsDao shardsDao) {
        return new RemoveShardTaskHandler(coremon, shardsDao, executor(), timer());
    }

    @Bean
    public DeleteMetricsTaskHandler deleteMetricsTaskHandler(
        SolomonConfHolder confHolder,
        CoremonClient coremon,
        DeleteMetricsOperationManager operationManager,
        DeleteMetricsOperationMetrics operationMetrics,
        DeleteMetricsOperationTracker operationTracker)
    {
        return new DeleteMetricsTaskHandler(
            confHolder,
            coremon,
            operationManager,
            operationMetrics,
            operationTracker,
            executor(),
            timer());
    }

    @Bean
    public ShardsManager.ShardRemoveHandler shardManagerRemoveShard(TaskScheduler scheduler) {
        return shard -> scheduler.schedule(RemoveShardTaskHandler.removeShardTask(shard.getProjectId(), shard.getId(), shard.getNumId()));
    }
}
