package ru.yandex.solomon.gateway.inject.spring;

import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.gateway.operations.db.LongRunningOperationDao;
import ru.yandex.solomon.gateway.operations.db.ydb.YdbLongRunningOperationDao;
import ru.yandex.solomon.selfmon.mon.DaoMetricsProxy;

/**
 * @author Stanislav Kashirin
 */
@Configuration
public class LongRunningOperationContext {

    @Bean
    LongRunningOperationDao longRunningOperationDao(
        @Qualifier("configKikimrRootPath") String rootPath,
        TableClient tableClient,
        MetricRegistry registry)
    {
        var dao = new YdbLongRunningOperationDao(rootPath + "/Gateway/V1", tableClient);
        return measure(dao, LongRunningOperationDao.class, registry);
    }

    private static <TDao> TDao measure(TDao dao, Class<TDao> daoClass, MetricRegistry registry) {
        return DaoMetricsProxy.of(dao, daoClass, registry);
    }
}
