package ru.yandex.solomon.gateway.inject.spring;

import java.util.List;
import java.util.Optional;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.solomon.alert.client.AlertingClient;
import ru.yandex.solomon.config.protobuf.frontend.ShardMetricsCurrentValueConfig;
import ru.yandex.solomon.core.conf.ShardMetricsQuotaReader;
import ru.yandex.solomon.core.db.dao.QuotasDao;
import ru.yandex.solomon.gateway.data.DataClient;
import ru.yandex.solomon.gateway.data.ShardMetricsQuotaReaderImpl;
import ru.yandex.solomon.quotas.manager.QuotaFetcher;
import ru.yandex.solomon.quotas.manager.QuotaManager;
import ru.yandex.solomon.quotas.manager.fetcher.AlertingQuotaFetcher;

/**
 * @author Ivan Tsybulin
 */
@Configuration
public class QuotaManagerContext {
    @Bean
    QuotaFetcher alertingQuotaFetcher(AlertingClient alertingClient) {
        return new AlertingQuotaFetcher(alertingClient);
    }

    @Bean
    QuotaManager quotaManager(QuotasDao quotasDao, List<QuotaFetcher> quotaFetchers) {
        return new QuotaManager(quotasDao, quotaFetchers);
    }

    @Bean
    ShardMetricsQuotaReader shardMetricsQuotaReader(DataClient dataClient, Optional<ShardMetricsCurrentValueConfig> config) {
        return new ShardMetricsQuotaReaderImpl(dataClient, config.orElse(null));
    }
}
