package ru.yandex.solomon.gateway.inject.spring;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.alert.client.AlertApi;
import ru.yandex.solomon.auth.Authorizer;
import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.gateway.api.v3.intranet.AlertingStubRequestService;
import ru.yandex.solomon.gateway.api.v3.intranet.ResourceService;
import ru.yandex.solomon.gateway.api.v3.intranet.impl.AlertingStubRequestServiceImpl;
import ru.yandex.solomon.gateway.stub.dao.StubRequestDao;
import ru.yandex.solomon.gateway.stub.dao.ydb.YdbStubRequestDao;
import ru.yandex.solomon.idempotency.IdempotentOperationService;
import ru.yandex.solomon.selfmon.mon.DaoMetricsProxy;

/**
 * @author Nuradil Zhambyl
 */
@Configuration
@ParametersAreNonnullByDefault
public class StubRequestContext {

    private final SchemeClient schemeClient;
    private final TableClient tableClient;
    private final String rootSchema;
    private final String PATH_DAO = "/Config/V2";
    private final MetricRegistry metricRegistry;

    @Autowired
    public StubRequestContext(
            TableClient tableClient,
            SchemeClient schemeClient,
            @Qualifier("configKikimrRootPath") String rootSchema,
            MetricRegistry metricRegistry)
    {
        this.schemeClient = schemeClient;
        this.tableClient = tableClient;
        this.rootSchema = rootSchema;
        this.metricRegistry = metricRegistry;
    }

    @Bean
    public StubRequestDao stubRequestDao() {
        var dao = new YdbStubRequestDao(rootSchema + PATH_DAO,
                rootSchema + GatewayIdempotentOperationContext.PATH,
                tableClient,
                schemeClient);
        dao.createSchemaForTests();
        return measure(dao, StubRequestDao.class);
    }

    @Bean
    public AlertingStubRequestService alertingStubRequestService(
            StubRequestDao dao,
            IdempotentOperationService idempotentOperationService,
            SolomonConfHolder confHolder,
            Authorizer authorizer,
            AlertApi alertApi,
            ResourceService resourceService)
    {
        var service = new AlertingStubRequestServiceImpl(
                dao,
                idempotentOperationService,
                confHolder,
                authorizer,
                alertApi,
                resourceService);
        return service;
    }

    private <TDao> TDao measure(TDao dao, Class<TDao> daoClass) {
        return DaoMetricsProxy.of(dao, daoClass, metricRegistry);
    }
}
