package ru.yandex.solomon.gateway.operations;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;

import ru.yandex.solomon.core.container.ContainerType;

import static java.util.Objects.requireNonNull;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public record LongRunningOperation(
    String operationId,
    LongRunningOperationType operationType,
    String containerId,
    ContainerType containerType,
    String description,
    long createdAt,
    String createdBy,
    long updatedAt,
    int status,
    Any data,
    int version)
{

    public LongRunningOperation {
        requireNonNull(operationId);
        requireNonNull(operationType);
        requireNonNull(containerId);
        requireNonNull(containerType);
        requireNonNull(description);
        requireNonNull(createdBy);
        requireNonNull(data);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @ParametersAreNonnullByDefault
    public static class Builder {

        private String operationId;
        private LongRunningOperationType operationType;
        private String containerId;
        private ContainerType containerType;
        private String description;
        private long createdAt;
        private String createdBy;
        private long updatedAt;
        private int status;
        private Any data = Any.getDefaultInstance();
        private int version;

        private Builder() {
        }

        private Builder(LongRunningOperation operation) {
            this.operationId = operation.operationId();
            this.operationType = operation.operationType();
            this.containerId = operation.containerId();
            this.containerType = operation.containerType();
            this.description = operation.description();
            this.createdAt = operation.createdAt();
            this.createdBy = operation.createdBy();
            this.updatedAt = operation.updatedAt();
            this.status = operation.status();
            this.data = operation.data();
            this.version = operation.version();
        }

        public Builder setOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder setOperationType(LongRunningOperationType operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder setContainerId(String containerId) {
            this.containerId = containerId;
            return this;
        }

        public Builder setContainerType(ContainerType containerType) {
            this.containerType = containerType;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setCreatedAt(long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder setUpdatedAt(long updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder setStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder setData(Any data) {
            this.data = data;
            return this;
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public LongRunningOperation build() {
            return new LongRunningOperation(
                operationId,
                operationType,
                containerId,
                containerType,
                description,
                createdAt,
                createdBy,
                updatedAt,
                status,
                data,
                version);
        }
    }

}
