package ru.yandex.solomon.gateway.operations.db;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.container.ContainerType;
import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.gateway.operations.LongRunningOperation;
import ru.yandex.solomon.gateway.operations.LongRunningOperationType;
import ru.yandex.solomon.ydb.page.TokenBasePage;
import ru.yandex.solomon.ydb.page.TokenPageOptions;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public interface LongRunningOperationDao extends SchemaAwareDao {

    CompletableFuture<Boolean> insert(LongRunningOperation operation);

    CompletableFuture<Optional<LongRunningOperation>> insertIfAbsent(LongRunningOperation operation);

    CompletableFuture<Optional<LongRunningOperation>> findOne(String operationId);

    CompletableFuture<Optional<LongRunningOperation>> update(LongRunningOperation operation);

    CompletableFuture<TokenBasePage<LongRunningOperation>> list(
        ContainerType containerType,
        String containerId,
        LongRunningOperationType operationType,
        TokenPageOptions pageOpts);

    CompletableFuture<Long> count(
        ContainerType containerType,
        String containerId,
        LongRunningOperationType operationType,
        long createdSince,
        int limit);
}
