package ru.yandex.solomon.gateway.operations.deleteMetrics;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.logbroker.agent.client.Client;
import ru.yandex.logbroker.agent.client.SessionMetrics;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.frontend.DeleteMetricsConfig;
import ru.yandex.solomon.config.protobuf.frontend.DeleteMetricsOperationTrackerConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.gateway.inject.spring.LongRunningOperationContext;
import ru.yandex.solomon.gateway.operations.db.LongRunningOperationDao;
import ru.yandex.solomon.spring.ConditionalOnBean;
import ru.yandex.solomon.spring.ConditionalOnMissingBean;
import ru.yandex.solomon.unified.agent.UnifiedAgentClients;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
@Configuration
@Import({
    LongRunningOperationContext.class,
})
public class DeleteMetricsContext {

    @Bean
    public DeleteMetricsOperationManager deleteMetricsOperationManager(LongRunningOperationDao dao) {
        return new DeleteMetricsOperationManager(dao);
    }

    @Bean
    public DeleteMetricsOperationMetrics deleteMetricsOperationMetrics(
        MetricRegistry registry,
        DeleteMetricsConfig config)
    {
        return new DeleteMetricsOperationMetrics(registry, config);
    }

    @Qualifier("deleteMetricsOperationTracker")
    @Bean
    @ConditionalOnBean(DeleteMetricsOperationTrackerConfig.class)
    public Client deleteMetricsUaClient(
        DeleteMetricsOperationTrackerConfig config,
        MetricRegistry registry,
        ThreadPoolProvider threads)
    {
        return UnifiedAgentClients.makeClient(config.getUnifiedAgentClient(), threads, registry);
    }

    @Bean
    @ConditionalOnBean(DeleteMetricsOperationTrackerConfig.class)
    public DeleteMetricsOperationTracker deleteMetricsOperationTracker(
        @Qualifier("deleteMetricsOperationTracker") Client client,
        MetricRegistry registry)
    {
        var session = client.newSession()
            .setMetrics(new SessionMetrics(registry.subRegistry("session", "delete_metrics")))
            .build();

        return new DeleteMetricsOperationTrackerImpl(session);
    }

    @Bean
    @ConditionalOnMissingBean(DeleteMetricsOperationTrackerConfig.class)
    public DeleteMetricsOperationTracker deleteMetricsOperationTrackerNoOp() {
        return new DeleteMetricsOperationTrackerNoOp();
    }

    @Bean
    @ConditionalOnBean(DeleteMetricsOperationTrackerConfig.class)
    public DeleteMetricsOperationTrackerHistoryPatch deleteMetricsOperationTrackerHistoryPatch(
        DeleteMetricsOperationManager manager,
        DeleteMetricsOperationTracker tracker)
    {
        return new DeleteMetricsOperationTrackerHistoryPatch(manager, tracker);
    }
}
