package ru.yandex.solomon.gateway.operations.deleteMetrics;

import java.util.Arrays;
import java.util.List;

import static java.util.stream.Collectors.toUnmodifiableList;

/**
 * @author Stanislav Kashirin
 */
public enum DeleteMetricsOperationStatus {
    STATUS_UNSPECIFIED(0),
    DELETING(1),
    WAITING_FOR_PERMANENT_DELETION(2),
    DELETING_PERMANENTLY(3),
    COMPLETED(4),
    CANCELLING(5),
    CANCELLED(6),
    FAILED(7),
    METRICS_HAVE_RECENT_WRITES(8);

    private static final DeleteMetricsOperationStatus[] VALUES = values();
    private static final List<DeleteMetricsOperationStatus> TERMINAL =
        Arrays.stream(VALUES)
            .filter(DeleteMetricsOperationStatus::isTerminal)
            .collect(toUnmodifiableList());

    public static DeleteMetricsOperationStatus fromValue(int value) {
        return VALUES[value];
    }

    public static List<DeleteMetricsOperationStatus> terminal() {
        return TERMINAL;
    }

    public final int value;

    DeleteMetricsOperationStatus(int value) {
        this.value = value;
    }

    public boolean isTerminal() {
        return this == COMPLETED
            || this == CANCELLED
            || this == FAILED
            || this == METRICS_HAVE_RECENT_WRITES;
    }
}
