package ru.yandex.solomon.gateway.operations.deleteMetrics;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.container.ContainerType;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public interface DeleteMetricsOperationTracker extends AutoCloseable {

    void operationStarted(
        long tsMillis,
        String login,
        ContainerType containerType,
        String containerId,
        String operationId,
        String selectors);

    void operationCancelled(
        long tsMillis,
        String login,
        ContainerType containerType,
        String containerId,
        String operationId);

    void operationTerminated(
        long tsMillis,
        ContainerType containerType,
        String containerId,
        String operationId,
        DeleteMetricsOperationStatus status,
        String statusMessage,
        int permanentlyDeletedMetricsCount);
}
