package ru.yandex.solomon.gateway.push;

import ru.yandex.solomon.model.protobuf.MetricFormat;

/**
 * @author Sergey Polovko
 */
public final class PushFormats {

    public static final String JSON = "application/json";
    public static final String SPACK = "application/x-solomon-spack";
    public static final String SOLOMON_PB = "application/x-solomon-pb";
    public static final String PROMETHEUS_PB = "application/x-protobuf";

    private PushFormats() {}

    public static MetricFormat byContentType(String contentType) {
        return switch (contentType) {
            case JSON -> MetricFormat.JSON;
            case SPACK -> MetricFormat.SPACK;
            case SOLOMON_PB -> MetricFormat.PROTOBUF;
            case PROMETHEUS_PB -> MetricFormat.PROMETHEUS;
            default -> MetricFormat.METRIC_FORMAT_UNSPECIFIED;
        };
    }

    public static MetricFormat byMonitoringContentType(String contentType) {
        return switch (contentType) {
            case JSON -> MetricFormat.MONITORING_JSON;
            case SPACK -> MetricFormat.SPACK;
            case SOLOMON_PB -> MetricFormat.PROTOBUF;
            case PROMETHEUS_PB -> MetricFormat.PROMETHEUS;
            default -> MetricFormat.METRIC_FORMAT_UNSPECIFIED;
        };
    }
}
