package ru.yandex.solomon.gateway.push;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;

import ru.yandex.solomon.auth.Account;
import ru.yandex.solomon.labels.shard.ShardKey;
import ru.yandex.solomon.model.protobuf.MetricFormat;

/**
 * @author Sergey Polovko
 */
public class PushRequest {

    private final ShardKey shardKey;
    private final MetricFormat format;
    private final Account account;
    private final int contentSizeBytes;
    private ByteBuf content;

    public PushRequest(ShardKey shardKey, MetricFormat format, ByteBuf content, int contentSizeBytes, Account account) {
        this.shardKey = shardKey;
        this.format = format;
        this.content = content;
        this.account = account;
        this.contentSizeBytes = contentSizeBytes;
    }

    public ShardKey getShardKey() {
        return shardKey;
    }

    public MetricFormat getFormat() {
        return format;
    }

    public ByteBuf takeContent() {
        ByteBuf content = this.content;
        Preconditions.checkNotNull(content);
        this.content = null;
        return content;
    }

    public int getContentSizeBytes() {
        return contentSizeBytes;
    }

    public Account getAccount() {
        return account;
    }
}
