package ru.yandex.solomon.gateway.push;

import java.util.concurrent.ConcurrentHashMap;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.proto.UrlStatusType;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
class PushShardFormatMetrics {

    private final MetricRegistry registry;
    private final Labels commonLabels;

    private final Rate metricsProcessed;
    private final ConcurrentHashMap<UrlStatusType, Rate> notOkUrlStatusCount;

    private final Rate okCount;
    private final Rate notOkTotalCount;

    PushShardFormatMetrics(MetricRegistry registry, String format) {
        this.registry = registry;
        this.commonLabels = Labels.of("sensorsFormat", format);
        this.metricsProcessed = registry.rate("push.shard.sensorsProcessed", commonLabels);
        this.notOkUrlStatusCount = new ConcurrentHashMap<>();
        this.okCount = createStatusMetric(UrlStatusType.OK.name());
        this.notOkTotalCount = createStatusMetric("NOT_OK");
    }

    void add(UrlStatusType urlStatusType, int metricsProcessed) {
        if (urlStatusType == UrlStatusType.OK) {
            okCount.inc();
            this.metricsProcessed.add(metricsProcessed);
        } else {
            notOkTotalCount.inc();
            getUrlStatusCountMetric(urlStatusType).inc();
        }
    }

    private Rate getUrlStatusCountMetric(UrlStatusType status) {
        return notOkUrlStatusCount.computeIfAbsent(status, _status -> createStatusMetric(_status.name()));
    }

    private Rate createStatusMetric(String pushStatus) {
        return registry.rate("push.shard.requests.total", commonLabels.add("pushStatus", pushStatus));
    }
}
