package ru.yandex.solomon.gateway.push;

import org.springframework.http.HttpStatus;

import ru.yandex.solomon.proto.UrlStatusType;


/**
 * @author Sergey Polovko
 */
public final class PushStatusToHttpStatus {
    private PushStatusToHttpStatus() {}

    public static HttpStatus convert(UrlStatusType status) {
        switch (status) {
            case OK:
                return HttpStatus.OK;

            case JSON_ERROR:
            case SPACK_ERROR:
            case PARSE_ERROR:
            case DERIV_AND_TS:
            case RESPONSE_TOO_LARGE:
            case SENSOR_OVERFLOW:
            case SHARD_IS_NOT_WRITABLE:
                return HttpStatus.BAD_REQUEST;

            case QUOTA_ERROR:
            case SKIP_TOO_LONG:
                return HttpStatus.PAYLOAD_TOO_LARGE;

            case UNKNOWN_PROJECT:
            case UNKNOWN_SHARD:
                return HttpStatus.NOT_FOUND;

            case SHARD_NOT_INITIALIZED:
            case IPC_QUEUE_OVERFLOW:
                return HttpStatus.SERVICE_UNAVAILABLE;

            case TIMEOUT:
                return HttpStatus.GATEWAY_TIMEOUT;

            case AUTH_ERROR:
                return HttpStatus.UNAUTHORIZED;

            default:
                return HttpStatus.INTERNAL_SERVER_ERROR;
        }
    }
}
