package ru.yandex.solomon.gateway.stub.dao;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.gateway.stub.StubRequest;
import ru.yandex.solomon.idempotency.IdempotentOperation;

/**
 * @author Nuradil Zhambyl
 */
public interface StubRequestDao extends SchemaAwareDao {
    CompletableFuture<Optional<StubRequest>> get(String id);
    CompletableFuture<Boolean> insert(StubRequest request, IdempotentOperation op);
    CompletableFuture<Boolean> deleteOne(String id, IdempotentOperation op);
}
