package ru.yandex.solomon.gateway.stub.dao.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Nuradil Zhambyl
 */
@ParametersAreNonnullByDefault
public class YdbStubRequestQuery {

    private static final String SELECT_ONE = """
            --!syntax_v1
            DECLARE $id AS Utf8;

            SELECT * FROM `TABLE` WHERE id = $id;
            """;

    private static final String INSERT = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $serviceProviderId AS Utf8;
            DECLARE $type AS Utf8;
            DECLARE $stub AS String;
            DECLARE $executedAt AS Timestamp;
            DECLARE $completedAt AS Timestamp;
            DECLARE $operationId AS Utf8;
            DECLARE $containerId AS Utf8;
            DECLARE $containerType AS Utf8;
            DECLARE $operationType AS Utf8;
            DECLARE $entityId AS Utf8;
            DECLARE $result AS String;

            $operationResult = (
               SELECT
                $operationId AS id,
                $containerId AS containerId,
                $containerType AS containerType,
                $operationType AS operationType,
                $entityId AS entityId,
                $result AS result,
                $completedAt AS completedAt
            );

            INSERT INTO `OPERATIONS` SELECT * from $operationResult WHERE id = $operationId and $operationId <> 'NO_OPERATION_ID';

            INSERT INTO `TABLE`(id, serviceProviderId, type, stub, executedAt)
            VALUES ($id, $serviceProviderId, $type, $stub, $executedAt);
            """;

    private static final String DELETE = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $operationId AS Utf8;
            DECLARE $containerId AS Utf8;
            DECLARE $containerType AS Utf8;
            DECLARE $operationType AS Utf8;

            $operationResult = (
               SELECT
                $operationId AS id,
                $containerId AS containerId,
                $containerType AS containerType,
                $operationType AS operationType,
            );

            INSERT INTO `OPERATIONS` SELECT * from $operationResult WHERE id = $operationId and $operationId <> 'NO_OPERATION_ID';

            SELECT TRUE AS value
            FROM `TABLE`
            WHERE id = $id;

            DELETE FROM `TABLE`
            WHERE id = $id;
            """;

    private static final String OPERATION_EXISTS = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $containerId AS Utf8;
            DECLARE $containerType AS Utf8;
            DECLARE $operationType AS Utf8;

            SELECT TRUE FROM `OPERATIONS` WHERE id = $id and containerId = $containerId and containerType = $containerType and operationType = $operationType;
            """;

    final String root;
    final String table;
    final String tableOperations;
    final String insert;
    final String selectOne;
    final String deleteOne;
    final String operationExists;

    public YdbStubRequestQuery(String root, String operationsRoot) {
        this.root = root;
        this.table = root + "/StubRequest";
        this.tableOperations = operationsRoot + "/IdempotentOperation";
        this.selectOne = prepare(SELECT_ONE);
        this.insert = prepare(INSERT);
        this.deleteOne = prepare(DELETE);
        this.operationExists = prepare(OPERATION_EXISTS);
    }

    private String prepare(String query) {
        return query
                .replaceAll("TABLE", table)
                .replaceAll("OPERATIONS", tableOperations);
    }
}
