package ru.yandex.solomon.gateway.stub.dao.ydb;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.ydb.core.Status;
import com.yandex.ydb.table.Session;
import com.yandex.ydb.table.description.TableDescription;
import com.yandex.ydb.table.settings.AutoPartitioningPolicy;
import com.yandex.ydb.table.settings.CreateTableSettings;
import com.yandex.ydb.table.settings.PartitioningPolicy;
import com.yandex.ydb.table.values.PrimitiveType;

/**
 * @author Nuradil Zhambyl
 */
@ParametersAreNonnullByDefault
public class YdbStubRequestTable {
    static String ID = "id";
    static String PARAM_ID = "$" + ID;
    static String SERVICE_PROVIDER_ID = "serviceProviderId";
    static String PARAM_SERVICE_PROVIDER_ID = "$" + SERVICE_PROVIDER_ID;
    static String TYPE = "type";
    static String PARAM_TYPE = "$" + TYPE;
    static String STUB = "stub";
    static String PARAM_STUB = "$" + STUB;
    static String EXECUTED_AT = "executedAt";
    static String PARAM_EXECUTED_AT = "$" + EXECUTED_AT;

    static CompletableFuture<Status> createTable(String tablePath, Session session) {
        var table = TableDescription.newBuilder()
                .addNullableColumn(ID, PrimitiveType.utf8())
                .addNullableColumn(SERVICE_PROVIDER_ID, PrimitiveType.utf8())
                .addNullableColumn(TYPE, PrimitiveType.utf8())
                .addNullableColumn(STUB, PrimitiveType.string())
                .addNullableColumn(EXECUTED_AT, PrimitiveType.timestamp())
                .setPrimaryKeys(ID)
                .build();

        var settings = new CreateTableSettings();
        settings.setPartitioningPolicy(new PartitioningPolicy().setAutoPartitioning(AutoPartitioningPolicy.AUTO_SPLIT_MERGE));
        settings.setTimeout(10, TimeUnit.SECONDS);

        return session.createTable(tablePath, table, settings);
    }
}
