package ru.yandex.solomon.gateway.tasks;

import java.util.concurrent.CompletableFuture;

/**
 * @author Stanislav Kashirin
 */
public interface SubTask<P> extends AutoCloseable {

    default CompletableFuture<Void> start(boolean interrupt) {
        return start(interrupt, () -> {});
    }

    CompletableFuture<Void> start(boolean interrupt, Runnable onProgressChange);

    boolean isIdle();

    P progress();

    @Override
    void close();
}
